import 'package:absenkuv3/Bloc/Absensi/AbsensiBloc.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/CameraX/Bloc/FaceXBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';

class HalamanAbsensi extends StatefulWidget {
  const HalamanAbsensi({super.key});

  @override
  State<HalamanAbsensi> createState() => _HalamanAbsensiState();
}

class _HalamanAbsensiState extends State<HalamanAbsensi>
    with WidgetsBindingObserver {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  @override
  void initState() {
    BlocProvider.of<AbsensiBloc>(context).add(CekAbsenEvent(context));
    BlocProvider.of<FaceXBloc>(context).add(InitialDialog(context));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: Scaffold(
        key: scaffoldKey,
        backgroundColor: CustomStyle.backgroundDashboardColor,
        body: BlocBuilder<AuthBloc, LoginRespon>(
            builder: (BuildContext context, LoginRespon loginRespon) {
          return BlocListener<AbsensiBloc, AbsensiState>(
            listener: (BuildContext context, AbsensiState state) {
              if (state is PeringatanState) {}
            },
            child: FutureBuilder<PageAbsensiModel>(
                future: PengaturanBahasa().absensi(),
                builder: (context, snapshot) {
                  if (snapshot.connectionState == ConnectionState.done) {
                    return BlocListener<AbsensiBloc, AbsensiState>(
                      listener: (BuildContext context, AbsensiState state) {
                        if (state is PeringatanState &&
                            snapshot.connectionState == ConnectionState.done) {
                          // jenisPeringatan = state.jenisPeringatan;
                          // messagePeringatan = state.message;
                          // popUpPeringatan(
                          //     state.message, context, snapshot.data!.absensi!);
                        }
                      },
                      child: BlocBuilder<AbsensiBloc, AbsensiState>(
                        builder: (context, state) {
                          // Set<Marker> _markers = {};
                          // Completer<GoogleMapController> _controller =Completer();
                          // CameraPosition _initPosition =
                          //     CameraPosition(target: LatLng(-6.9932, 110.4203));
                          if (state is AbsensiLoading) {
                            return Container(
                              height: double.infinity,
                              width: double.infinity,
                              child: Center(
                                  child: CircularProgressIndicator(
                                strokeWidth: 8,
                              )),
                            );
                          } else if (state is AbsensiFailure) {
                            return Container(
                              height: double.infinity,
                              width: double.infinity,
                              decoration: CustomStyle.boxDecoration,
                              child: Center(
                                child: Text(state.errorMessage),
                              ),
                            );
                          } else if (state is AbsensiSuccess) {
                            return Container();
                          } else {
                            return Container();
                          }
                        },
                      ),
                    );
                  } else {
                    return Container();
                  }
                }),
          );
        }),
      ),
    );
  }

  @override
  void dispose() {
    WidgetsBinding.instance.removeObserver(this);
    super.dispose();
  }

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateRemoveToDashboard(context));
    BlocProvider.of<AbsensiBloc>(context).add(LoadingEvent(context));

    return false;
  }
}
